﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="System.Collections.Generic" %>

<script runat="server">

    public class PrnParams : ContextBase {
        
        public PrnParams(Context context) : base(context) {
        }

        bool bledy = true;
        [Caption("Tylko błędne dane")]
        public bool Bledy {
            get { return bledy; }
            set {
                bledy = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    PrnParams pars;
    [Context(Required = true)]
    public PrnParams Params {
        set { pars = value; }
    }
        
    class Pozycja {
        string podmiot;
        public string Podmiot {
            get { return podmiot; }
            set { podmiot = value; }
        }
        string pesel;
        public string Pesel {
            get { return pesel; }
            set { pesel = value; }
        }
        decimal podst1;
        public decimal Podst1 {
            get { return podst1; }
            set { podst1 = value; }
        }
        decimal podst2;
        public decimal Podst2 {
            get { return podst2; }
            set { podst2 = value; }
        }
        decimal podst3;
        public decimal Podst3 {
            get { return podst3; }
            set { podst3 = value; }
        }
        decimal podst4;
        public decimal Podst4 {
            get { return podst4; }
            set { podst4 = value; }
        }
        public Pozycja(string podmiot, string pesel, decimal podst1, decimal podst2, decimal podst3, decimal podst4) {
            this.podmiot = podmiot;
            this.pesel = (pesel.Trim().Length == 0 ? "BRAK" : pesel);
            this.podst1 = podst1;
            this.podst2 = podst2;
            this.podst3 = podst3;
            this.podst4 = podst4;
        }
    }

    class ElementWyplatyComparer : IComparer<Pozycja> {
        public int Compare(Pozycja x, Pozycja y) {
            return x.Podmiot.CompareTo(y.Podmiot);
        }
    }
    
    void OnContextLoad(Object sender, EventArgs e) {
        Soneta.Deklaracje.ZUS.DRA dra = (Soneta.Deklaracje.ZUS.DRA)dc[typeof(Soneta.Deklaracje.ZUS.DRA)];
        if (dra == null) {
            throw new Exception("Wydruk przeznaczony tylko dla deklaracji DRA");
        }

        string podmiot, pesel;
        decimal podst1, podst2, podst3, podst4;

        List<Pozycja> pozycje = new List<Pozycja>();
        
        foreach (Deklaracja deklaracja in dra.Deklaracje) {
            string nazwa = string.Empty;
            if (deklaracja is Soneta.Deklaracje.ZUS.RCA)
                nazwa = "DDORCA";
            else if (deklaracja is Soneta.Deklaracje.ZUS.RSA)
                nazwa = "DDORSA";
            else if (deklaracja is Soneta.Deklaracje.ZUS.RZA)
                nazwa = "DDORZA";
            if (nazwa == string.Empty)
                continue;
            
            foreach (Deklaracja zalacznik in deklaracja.Deklaracje) {
                podmiot = zalacznik.Podmiot.Nazwa;
                pesel = "";
                if (zalacznik.Podmiot is Pracownik) {
                    Pracownik prac = (Pracownik)zalacznik.Podmiot;
                    pesel = prac.PESEL;
                    if (pesel.Length == 0)
                        if (prac[zalacznik.Data].Dokument.Rodzaj == KodRodzajuDokumentu.Paszport)
                            pesel = prac[zalacznik.Data].Dokument.SeriaNumer;
                }

                BlokDeklaracji blok = zalacznik.Bloki[nazwa];
                podst1 = podst2 = podst3 = podst4 = 0;                
                if (nazwa == "DDORCA") {
                    podst1 = (decimal)blok["PodstER"];
                    podst2 = (decimal)blok["PodstC"];
                    podst3 = (decimal)blok["PodstW"];
                }
                if (nazwa == "DDORCA" || nazwa == "DDORZA")
                    podst4 = (decimal)blok["PodstZ"];

                if (!pars.Bledy || pesel == "" || podst1 < 0 || podst2 < 0 || podst3 < 0 || podst4 < 0)   
                    pozycje.Add(new Pozycja(podmiot, pesel, podst1, podst2, podst3, podst4));
            }
        }

        pozycje.Sort(new ElementWyplatyComparer());
        Grid1.DataSource = pozycje;
    }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Deklaracja DRA</title> 
    <meta content="False" name="vs_showGrid" />
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<BODY>
        <FORM id="DeklaracjaZCNA" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Deklaracja DRA"></eb:ReportHeader>
			<font face="Tahoma" size="2">
                <p>
                    <b>Uwaga:
                    <br />
                    1. Jeżeli którykolwiek z ubezpieczonych nie ma uzupełnionego nr PESEL lub nr paszportu, przy wczytywaniu deklaracji do Programu Płatnik pojawi się błąd.
                    <br />
                    2. Program Płatnik nie przyjmuje deklaracji, w której znajdują się ujemne podstawy składek lub składki.
                    </b>
                </p>
            </font>            
            <ea:Grid id="Grid1" runat="server" GroupLine="{0}" GroupData0="Podmiot">
				<Columns>
					<ea:GridColumn runat="server" Align="Left" Caption="Pesel / Nr paszportu" DataMember="Pesel"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Podstawa emerytalna" DataMember="Podst1" Width="15"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Podstawa rentowa" DataMember="Podst1" Width="15"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Podstawa chorobowa" DataMember="Podst2" Width="15"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Podstawa wypadkowa" DataMember="Podst3" Width="15"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Podstawa zdrowotna" DataMember="Podst4" Width="15"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</html>
